<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes([
    "register"=>false,
     "verify"=>false
]);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');




// Banner Controller
Route::get('/add/banner', [App\Http\Controllers\BannerController::class, 'add_banner_view'])->name('add.banner');
Route::post('/add/banner', [App\Http\Controllers\BannerController::class, 'saveBanner'])->name('save.banner');
Route::post('/update/banner', [App\Http\Controllers\BannerController::class, 'updateBanner'])->name('update.banner');
Route::get('/list/banner', [App\Http\Controllers\BannerController::class, 'list_banner_view'])->name('add.list');
Route::get('/edit/{id}/banner', [App\Http\Controllers\BannerController::class, 'edit_banner'])->name('edit.banner');
Route::get('/delete/banner/{id}', [App\Http\Controllers\BannerController::class, 'delete'])->name('delete.banner');

// Service Controller 

Route::get('/add/service', [App\Http\Controllers\ServicesController::class, 'add_service_view'])->name('add.service');
Route::get('/list/service', [App\Http\Controllers\ServicesController::class, 'list_service_view'])->name('list.service');
Route::get('/delete/service/{id}', [App\Http\Controllers\ServicesController::class, 'delete'])->name('delete.service');
Route::get('/edit/{id}/service', [App\Http\Controllers\ServicesController::class, 'edit_service'])->name('edit.service');
Route::post('/add/service', [App\Http\Controllers\ServicesController::class, 'addService'])->name('save.service');
Route::post('/update/service', [App\Http\Controllers\ServicesController::class, 'updateService'])->name('update.service');



Route::get('/add/event/{type}/{heading}', [App\Http\Controllers\EventController::class, 'add_event_view'])->name('add.events');
Route::post('/add/event', [App\Http\Controllers\EventController::class, 'addEvent'])->name('save.events');
Route::get('/list/event/{type}/{heading}', [App\Http\Controllers\EventController::class, 'list_event_view'])->name('list.events');
Route::post('/update/event', [App\Http\Controllers\EventController::class, 'updateEvent'])->name('update.events');
Route::get('/event/{id}/edit', [App\Http\Controllers\EventController::class, 'edit'])->name('edit.events');
Route::get('/event/delete/{id}', [App\Http\Controllers\EventController::class, 'deleteEvent'])->name('delete.events');


// VideoController
Route::get('/add/video', [App\Http\Controllers\VideosController::class, 'add_video_view'])->name('add.videos');
Route::post('/add/video', [App\Http\Controllers\VideosController::class, 'addVideo'])->name('save.videos');
Route::post('/update/video', [App\Http\Controllers\VideosController::class, 'updateVideo'])->name('update.videos');
Route::get('/list/video', [App\Http\Controllers\VideosController::class, 'all_videos'])->name('list.videos');
Route::get('/list/{id}/edit', [App\Http\Controllers\VideosController::class, 'edit'])->name('edit.videos');
Route::get('/list/delete/{id}', [App\Http\Controllers\VideosController::class, 'deleteVideo'])->name('delete.videos');


//FeaturesController  

Route::get('/add/feature', [App\Http\Controllers\FeaturesController::class, 'add_feature_view'])->name('add.features');
Route::get('/list/feature', [App\Http\Controllers\FeaturesController::class, 'list_feature_view'])->name('list.features');
Route::post('/add/feature', [App\Http\Controllers\FeaturesController::class, 'saveFeature'])->name('save.features');
Route::get('/feature/{id}/edit', [App\Http\Controllers\FeaturesController::class, 'edit_feature'])->name('edit.features');
Route::post('update/feature', [App\Http\Controllers\FeaturesController::class, 'updateFeature'])->name('update.features');
Route::get('delete/feature/{id}', [App\Http\Controllers\FeaturesController::class, 'delete'])->name('delete.features');


// Testimonials Controller
Route::get('add/client', [App\Http\Controllers\TestimonialsController::class, 'add_client_view'])->name('add.client');
Route::get('list/client', [App\Http\Controllers\TestimonialsController::class, 'list_client_view'])->name('list.client');
Route::post('add/client', [App\Http\Controllers\TestimonialsController::class, 'saveClient'])->name('save.client');
Route::post('update/client', [App\Http\Controllers\TestimonialsController::class, 'updateClient'])->name('update.client');
Route::get('client/{id}/edit', [App\Http\Controllers\TestimonialsController::class, 'edit'])->name('edit.client');
Route::get('client/delete/{id}', [App\Http\Controllers\TestimonialsController::class, 'deleteTestimonial'])->name('delete.client');



// Team Controller
Route::get('project/view', [App\Http\Controllers\TeamController::class, 'project_data_view'])->name('project.view');
Route::get('add/team', [App\Http\Controllers\TeamController::class, 'add_client_view'])->name('add.team');
Route::get('list/team', [App\Http\Controllers\TeamController::class, 'list_client_view'])->name('list.team');
Route::post('add/team', [App\Http\Controllers\TeamController::class, 'saveClient'])->name('save.team');
Route::post('update/team', [App\Http\Controllers\TeamController::class, 'updateClient'])->name('update.team');
Route::get('team/{id}/edit', [App\Http\Controllers\TeamController::class, 'edit'])->name('edit.team');
Route::get('team/delete/{id}', [App\Http\Controllers\TeamController::class, 'deleteTestimonial'])->name('delete.team');


Route::post('add/project', [App\Http\Controllers\TeamController::class, 'addProject'])->name('save.project');
Route::get('project/{id}/editProject', [App\Http\Controllers\TeamController::class, 'editProject'])->name('edit.project');
Route::get('project/delete/{id}', [App\Http\Controllers\TeamController::class, 'deleteProject'])->name('delete.project');



//GeneralController 


Route::get('seo/setting', [App\Http\Controllers\GeneralController::class, 'seo_setting'])->name('seo.setting');
Route::post('save/setting', [App\Http\Controllers\GeneralController::class, 'saveSeo'])->name('save.seo');
Route::get('general/setting', [App\Http\Controllers\GeneralController::class, 'system_setting'])->name('general.setting');
Route::post('save/general/setting', [App\Http\Controllers\GeneralController::class, 'save_system_setting'])->name('save.setting');
Route::get('add/page/{about_us}', [App\Http\Controllers\GeneralController::class, 'about_us'])->name('add.aboutus');
Route::post('save/general', [App\Http\Controllers\GeneralController::class, 'addGeneral'])->name('save.general');

//FaqController

Route::get('add/faq', [App\Http\Controllers\FaqController::class, 'add_faq_view'])->name('add.faq');
Route::post('add/faq', [App\Http\Controllers\FaqController::class, 'saveFaq'])->name('save.faq');
Route::post('update/faq', [App\Http\Controllers\FaqController::class, 'updateFaq'])->name('update.faq');
Route::get('list/faq', [App\Http\Controllers\FaqController::class, 'list_faq_view'])->name('list.faq');
Route::get('faq/{id}/edit', [App\Http\Controllers\FaqController::class, 'edit'])->name('edit.faq');
Route::get('/delete/faq/{id}', [App\Http\Controllers\FaqController::class, 'delete'])->name('delete.faq');
