@extends('layouts.master')
@section('content')

    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Teams Lists</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="QA_section">
                    <div class="QA_table mb_30">

                        <table class="table lms_table_active ">
                            <thead>
                                <tr>
                                    <th scope="col">ID</th>
                                    <th scope="col">Team Name</th>
                                    <th scope="col">Job Post</th>
                                    <th scope="col">Short Details</th>
                                    <th scope="col">Team Profile</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($clients)
                                    @foreach ($clients as $index => $list)
                                        <tr>
                                            <th scope="row"> <a href="#"
                                                    class="question_content">{{ ++$index }}</a></th>
                                            <td>{{ $list->client_name }}</td>
                                            <td>{{ $list->client_post }}</td>
                                            <td>{{ $list->client_message }}</td>
                                            <td>
                                                <img
                                                 style="height:100px;width:100px;"
                                                src="{{ asset($list->image) }}"  />
                                            </td>

                                            <td>
                                                <div class="action_btns d-flex">
                                                    <a href="{{ route('edit.client', $list->id) }}"
                                                        class="action_btn mr_10 "> <i class="far fa-edit"></i>
                                                    </a>
                                                    <a href="javascript::void()"
                                                        onclick="deleteTestimonial({{ $list->id }})" class="action_btn"> <i
                                                            class="fas fa-trash"></i> </a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                @endif

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function deleteTestimonial(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('team/delete/') }}/" + id;
                }
            })
        }
    </script>
@endsection
