@extends('layouts.master')
@section('content')
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">General Setting</h3>
                    </div>
                </div>
            </div>
            <div class="white_card_body">
                <div class="card-body">
                    <form method="POST" action="{{ route('save.setting') }}" enctype="multipart/form-data">
                        @csrf
                        @if ($settings)
                            <input type="hidden" name="id" value="{{ $settings->id }}" />
                        @endif
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="heading">Company Title</label>
                                <input type="text" 
                                @if ($settings) value="{{$settings->company_title}}"  @endif
                                required name="company_title" class="form-control" id="heading"
                                    placeholder="Enter Title">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Email</label>
                                <input
                                @if ($settings) value="{{$settings->email}}"  @endif
                                type="email" required name="email" class="form-control" id="job_post"
                                    placeholder="Enter Email">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Phone Number</label>
                                <input 
                                @if ($settings) value="{{$settings->phone}}"  @endif
                                type="text" required name="phone" class="form-control" id="job_post"
                                    placeholder="Enter Phone Number">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Address</label>
                                <input 
                                @if ($settings) value="{{$settings->address}}"  @endif
                                type="text" required name="address" class="form-control" id="job_post"
                                    placeholder="Enter Address">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="profile_image">Company Logo</label>
                                <input
                                type="file" @if (!$settings)  required  @endif  name="logo" id="profile_image" class="form-control">
                            </div>
                            @if ($settings)
                            <div class="col-md-6">
                                <label class="form-label" for="profile_image">Old Logo</label>
                                <img src="{{ asset($settings->logo) }}" style="height: 150px;" />
                            </div>
                            @endif
                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Footer About Us</label>
                                <textarea type="text" required name="footer_about_us" class="form-control" id="job_post"
                                    placeholder="#">  @if ($settings){{$settings->footer_about_us}} @endif</textarea>
                            </div>


                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Facebook URL</label>
                                <input type="text" 
                                  @if ($settings) value="{{$settings->facebook_url}}"  @endif
                                    required name="facebook_url" class="form-control" id="job_post"
                                    placeholder="#">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Twitter/X URL</label>
                                <input type="text" required name="twitter_url" 
                                 @if ($settings) value="{{$settings->twiiter_url}}"  @endif class="form-control" id="job_post"
                                    placeholder="#">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Linkdin URL</label>
                                <input type="text"   @if ($settings) value="{{$settings->linkdin_url}}"  @endif required 
                                name="linkdin_url" class="form-control" id="job_post"
                                    placeholder="#">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="job_post">Instagram URL</label>
                                <input type="text" required name="instagram_url"  @if ($settings) value="{{$settings->instagram_url}}"  @endif
                                class="form-control" id="job_post"
                                    placeholder="#">
                            </div>

                        </div>

                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
