@extends('layouts.master')
@section('content')
    <div class="col-lg-12">
        <div class="white_card card_height_100 mb_30">
            <div class="white_card_header">
                <div class="box_header m-0">
                    <div class="main-title">
                        <h3 class="m-0">Edit {{ucwords($event->type)}}</h3>
                    </div>
                </div>
            </div>

            <div class="white_card_body">
                <div class="card-body">
                    <form method="POST" action="{{ route('update.events') }}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" value="{{$event->id}}"  name="id" />

                        <input type="hidden" value="{{ $event->type}}" name="type" />
                        <input type="hidden" value="{{ $event->type}}s List" name="heading_" />


                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="heading">Heading</label>
                                <input type="text" name="heading" value="{{ $event->heading }}" required
                                    class="form-control" id="heading" placeholder="Enter Heading">
                            </div>
                            <div class=" col-md-6">
                                <label class="form-label" for="short_details">Short Details</label>
                                <input type="text" value="{{ $event->short_details }}" name="short_details" required
                                    class="form-control" id="short_details" placeholder="Short Details">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="inputAddress">{{ucwords($event->type)}} Image</label>
                                <input type="file" name="image_banner"  class="form-control" id="inputAddress">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label" for="inputAddress">Old Image</label>
                                <img src="{{ asset($event->display_image) }}" style="width:150px" />
                            </div>

                        </div>

                        <div class="mb-3">
                            <label class="form-label" for="inputAddress">{{ucwords($event->type)}} Date</label>
                            <input type="date" value="{{$event->event_date}}" name="event_date" required class="form-control" id="inputAddress">
                        </div>

                        <div class="col-12">
                            <label class="form-label" for="inputAddress">Full Details</label>
                            <textarea required   name="full_details" id="summernote">{{$event->details}}</textarea>
                        </div>

                        <button type="submit" class="btn btn-primary">Update Event</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
