<?php

namespace App\Http\Controllers;

use App\Models\ProjectData;
use App\Models\TestimonialsModel;
use Illuminate\Http\Request;

class TeamController extends Controller
{

    private $banner_path = "uploads/testimonials";

    public function add_client_view()
    {
        return view("team.add_team");
    }

    public function edit($id)
    {
        $client = TestimonialsModel::find($id);
        if (!$client) {
            return redirect(route("list.team"))->with("error", "Sorry result not found");
        }
        return view("team.edit_team", compact('client'));
    }
    public function list_client_view()
    {
        $clients = TestimonialsModel::where("type", "team")
            ->orderBy("id", "DESC")->get();
        return view("team.list_team", compact('clients'));
    }

    public function saveClient(Request $request)
    {
        $validation = $request->validate([
            'client_name' => 'required|string',
            'job_post' => 'required|string',
            'short_details' => 'required|string',
            'profile_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);


        $imageName = time() . '.' . $request->profile_image->extension();
        $request->profile_image->move(public_path($this->banner_path), $imageName);
        $client = new TestimonialsModel();
        $client->client_name = $request->client_name;
        $client->client_post = $request->job_post;
        $client->client_message = $request->short_details;
        $client->type = "team";
        $client->image = $this->banner_path . "/" . $imageName;
        $client->save();
        return redirect(route("add.team"))->with("success", "Team added successfully");
    }

    public function updateClient(Request $request)
    {
        $data  = array(
            'id' => 'required|integer',
            'client_name' => 'required|string',
            'job_post' => 'required|string',
            'short_details' => 'required|string',

        );

        if ($request->profile_image) {
            $data["profile_image"] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $client = TestimonialsModel::find($request->id);

        if (!$client) {
            return redirect(route("list.team"))->with("error", "Sorry requested data not found");
        }

        if ($request->profile_image) {
            $imageName = time() . '.' . $request->profile_image->extension();
            $request->profile_image->move(public_path($this->banner_path), $imageName);
            $client->image = $this->banner_path . "/" . $imageName;
        }

        $client->client_name = $request->client_name;
        $client->client_post = $request->job_post;
        $client->client_message = $request->short_details;
        $client->save();
        return redirect(route("list.team"))->with("success", "Team updated successfully");
    }

    public function deleteTestimonial($id)
    {
        TestimonialsModel::where("id", $id)->delete();
        return redirect(route("list.team"))->with("success", "Team deleted successfully");
    }

    public function project_data_view()
    {
        $project = ProjectData::all();
        return view("team.project", compact('project'));
    }


    public function editProject($id)
    {
        $project = ProjectData::where("id", $id)->first();

        return view("team.edit_project", compact('project'));
    }


    public function addProject(Request $request)
    {

        $validation = $request->validate([
            'heading' => 'required|string',
            'heading_value' => 'required|string',
            'icon' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);


        $imageName = time() . '.' . $request->icon->extension();
        $request->icon->move(public_path($this->banner_path), $imageName);

        $projectData = new ProjectData();
        $projectData->heading = $request->heading;
        $projectData->heading_value = $request->heading_value;
        $projectData->icon = $this->banner_path . "/" . $imageName;
        $projectData->save();

        return redirect(route("project.view"))->with("success", "Project data added successfully");
    }

    public function updateProject(Request $request)
    {
        $data  = array(
            'id' => 'required|integer',
            'client_name' => 'required|string',
            'job_post' => 'required|string',
            'short_details' => 'required|string',

        );

        if ($request->profile_image) {
            $data["profile_image"] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $client = TestimonialsModel::find($request->id);

        if (!$client) {
            return redirect(route("list.team"))->with("error", "Sorry requested data not found");
        }

        if ($request->profile_image) {
            $imageName = time() . '.' . $request->profile_image->extension();
            $request->profile_image->move(public_path($this->banner_path), $imageName);
            $client->image = $this->banner_path . "/" . $imageName;
        }

        $client->client_name = $request->client_name;
        $client->client_post = $request->job_post;
        $client->client_message = $request->short_details;
        $client->save();
        return redirect(route("list.team"))->with("success", "Team updated successfully");
    }
    public function deleteProject($id){
        ProjectData::where("id",$id)->delete();
        return redirect(route("project.view"))->with("success", "Team deleted successfully");
    }

}
