<?php

namespace App\Http\Controllers;

use App\Models\GeneralData;
use App\Models\SeoModel;
use App\Models\SystemSettings;
use Illuminate\Http\Request;

class GeneralController extends Controller
{

    private $banner_path = "uploads/settings";

    public  function about_us($type)
    {
        $title  = "";
        if ($type == "about_us") {
            $title  = "About Us";
        } else if ($type == "vision") {
            $title  = "Vision And Growth";
        } else if ($type == "e_news") {
            $title  = "E-Rate News";
        } else if ($type == "categories") {
            $title  = "Categories";
        } else if ($type == "guide_to_erate") {
            $title  = "Guide To Erate Program";
        } else if ($type == "community_page") {
            $title  = "Community Page";
        } else if ($type == "why_use_erate") {
            $title  = "Why Use An E-Rate Consultant";
        } else if ($type == "e_rate_app_process") {
            $title  = "E-Rate Application Process";
        } else if ($type == "e_rate_app_timeline") {
            $title  = "E-Rate Application Timeline & Process";
        } else if ($type == "e_rate_changes") {
            $title  = "E-Rate Changes";
        } else if ($type == "terms") {
            $title  = "Terms & Conditions";
        } else if ($type == "policey") {
            $title  = "Privacy Policy";
        }


        $general = GeneralData::where("type", $type)->first();
        return view("page", compact('title', 'type', 'general'));
    }

    public  function addGeneral(Request $request)
    {

        $validation = $request->validate([
            'full_details' => 'required',
            'title' => 'required',
            'type' => 'required'
        ]);

        if ($request->id) {
            $general = GeneralData::where("id", $request->id)->first();
        } else {
            $general = new GeneralData();
        }

        $general->data  = $request->full_details;
        $general->title  = $request->title;
        $general->type  = $request->type;
        $general->save();

        return redirect(route("add.aboutus", ['about_us' => $request->type]))
            ->with("success", "Page saved successfully");
    }


    public  function system_setting()
    {
        $settings = SystemSettings::first();
        return view("settings.general", compact('settings'));
    }

    public  function seo_setting()
    {
        $seo = SeoModel::first();
        return view("settings.seo", compact('seo'));
    }

    public function saveSeo(Request $request)
    {

        $data  = array(
            'title' => 'required|string',
            'tags' => 'required|string',
            'details' => 'required|string',

        );

        $validation = $request->validate($data);

        if ($request->id) {
            $seo =  SeoModel::find($request->id);
        } else {
            $seo =  new SeoModel();
        }

        $seo->title = $request->title;
        $seo->tags = $request->tags;
        $seo->details = $request->details;
        $seo->save();

        return redirect(route("seo.setting"))->with("success", "Seo updated successfully");
    }

    public function save_system_setting(Request $request)
    {

        $data  = array(
            'company_title' => 'required|string',
            'email' => 'required|string',
            'phone' => 'required|string',
            'address' => 'required|string',
            'footer_about_us' => 'required|string',
            'facebook_url' => 'required|string',
            'twitter_url' => 'required|string',
            'linkdin_url' => 'required|string',
            'instagram_url' => 'required|string',
        );

        if (!$request->id) {
            $data['logo'] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);

        if ($request->id) {
            $settings =  SystemSettings::find($request->id);
            if ($request->file("logo")) {
                $imageName = time() . '.' . $request->logo->extension();
                $request->logo->move(public_path($this->banner_path), $imageName);
                $settings->logo = $this->banner_path . "/" . $imageName;
            }
        } else {
            $settings =  new SystemSettings();
            $imageName = time() . '.' . $request->logo->extension();
            $request->logo->move(public_path($this->banner_path), $imageName);
            $settings->logo = $this->banner_path . "/" . $imageName;
        }


        $settings->company_title = $request->company_title;
        $settings->email = $request->email;
        $settings->phone = $request->phone;
        $settings->address = $request->address;
        $settings->footer_about_us = $request->footer_about_us;
        $settings->facebook_url = $request->facebook_url;
        $settings->twitter_url = $request->twitter_url;
        $settings->instagram_url = $request->instagram_url;
        $settings->linkdin_url = $request->linkdin_url;
        $settings->save();

        return redirect(route("general.setting"))->with("success", "Settings updated successfully");
    }
}
