<?php

namespace App\Http\Controllers;

use App\Models\EventModels;
use Illuminate\Http\Request;

class EventController extends Controller
{
    private  $event_path = "uploads/events";

    public function add_event_view($type, $heading)
    {
        return view("events.add_event", compact('type', 'heading'));
    }

    public function list_event_view($type, $heading)
    {
        $events =  EventModels::orderBy("id", "DESC")
            ->where("type", $type)->get();
        return view("events.list_event", compact('events', 'heading'));
    }

    public function addEvent(Request $request)
    {

        $validation = $request->validate([
            'heading' => 'required|string',
            'short_details' => 'required|string',
            'image_banner' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'event_date' => 'required|string',
            'type' => 'required|string',
            'full_details' => 'required|string',
        ]);


        $imageName = time() . '.' . $request->image_banner->extension();
        $request->image_banner->move(public_path($this->event_path), $imageName);
        $events = new EventModels();
        $events->heading = $request->heading;
        $events->short_details = $request->short_details;
        $events->event_date = $request->event_date;
        $events->details = $request->full_details;
        $events->type = $request->type;
        $events->display_image = $this->event_path . "/" . $imageName;
        $events->save();

        return redirect(route("list.events",['type'=>$request->type,'heading'=>$request->type.' List']))->with("success", "Event added successfully");
    }

    public function edit(Request $request, $id)
    {
       // $heading = $request->type;
        $event =  EventModels::find($id);
        if (!$event) {
            return redirect(route("list.events"))->with("error", "Sorry event not found");
        }

        return view("events.edit_event", compact('event'));
    }

    public function updateEvent(Request $request)
    {

        $data = array(
            [
                'id' => 'required|integer',
                'heading' => 'required|string',
                'short_details' => 'required|string',
                'event_date' => 'required|string',
                'full_details' => 'required|string',
                'type' => 'required|string',
            ]
        );


        if ($request->image_banner) {
            $data['image_banner'] = 'required|image|mimes:jpeg,png,jpg,gif|max:2048';
        }

        $validation = $request->validate($data);


        $events = EventModels::where("id", $request->id)->first();

        if ($request->image_banner) {
            $imageName = time() . '.' . $request->image_banner->extension();
            $request->image_banner->move(public_path($this->event_path), $imageName);
            $events->display_image = $this->event_path . "/" . $imageName;
        }

        $events->heading = $request->heading;
        $events->short_details = $request->short_details;
        $events->event_date = $request->event_date;
        $events->details = $request->full_details;
        $events->type = $request->type;
        $events->save();

        return redirect(route("list.events",['type'=>$request->type,'heading'=>$request->type.' List']))->with([
            "success"=> "Event updated successfully",
            "type" => $request->type
        ]);

    }
    public function deleteEvent($id)
    {
        $videomodel = EventModels::where("id", $id)->first();
        $type = $videomodel->type;
        $videomodel->delete();
        return redirect(route("list.events",['type'=>$type,'heading'=>$type.' List']))->with("success", "Event deleted successfully");
    }
}
